/**
 * Helper class used to play audio.
 */
class UISound {
	/**
	 * Class constructor.
	 *
	 * @param 	string  id  The ID attribute of the audio tag.
	 */
	constructor(id) {
		// load audio tag
		this.sound  = document.getElementById(id);
		this.status = true;
	}

	/**
	 * Tries to play the audio.
	 *
	 * @return 	self  This object to support chaining.
	 */
	play() {
		if (this.canPlay()) {
			this.sound.play();
		}

		return this;
	}

	/**
	 * Mutes the audio.
	 *
	 * @return 	self  This object to support chaining.
	 */
	mute() {
		this.status = false;

		return this;
	}

	/**
	 * Activates the audio.
	 *
	 * @return 	self  This object to support chaining.
	 */
	active() {
		this.status = true;

		return this;
	}

	/**
	 * Checks whether the audio has been muted or not.
	 *
	 * @return 	boolean  True if playable, false if muted.
	 */
	canPlay() {
		return this.status;
	}
}

// export for external usage
module.exports = UISound;
